/*
 * Decompiled with CFR 0.152.
 */
package OreSpawn.entities;

import OreSpawn.OreSpawnMain;
import OreSpawn.entities.Triffid;
import dangerzone.DangerZone;
import dangerzone.Explosion;
import dangerzone.TextureMapper;
import dangerzone.Utils;
import dangerzone.World;
import dangerzone.blocks.Blocks;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityLiving;
import java.util.List;
import java.util.ListIterator;
import java.util.Properties;
import org.newdawn.slick.opengl.Texture;

public class Island
extends EntityLiving {
    private float dir = 0.0f;
    private float speed = 0.1f;
    private int radius = 5;
    private int depth = 3;
    private int just_spawned = 1;
    private int ticker = 0;
    private int once = 1;
    private double myX;
    private double myZ;
    private int dirchange;

    public Island(World w) {
        super(w);
        this.maxrenderdist = 32;
        this.height = 0.5f;
        this.width = 0.5f;
        this.uniquename = "OreSpawn:Island";
        this.moveSpeed = 0.0f;
        this.setMaxHealth(30.0f);
        this.setHealth(30.0f);
        this.setDefense(0.5f);
        this.setAttackDamage(0.0f);
        this.movefrequency = 20000;
        this.setExperience(30);
        this.canSwim = false;
        this.takesFallDamage = false;
        this.ignoreCollisions = true;
        this.setCanDespawn(false);
        this.tower_defense_enable = false;
    }

    public void init() {
        super.init();
        this.ticker = DangerZone.rand.nextInt(50);
        this.dirchange = DangerZone.rand.nextInt(2500);
    }

    public void update(float deltaT) {
        if (!this.world.isServer) {
            super.update(deltaT);
            return;
        }
        this.motionz = 0.0f;
        this.motiony = 0.0f;
        this.motionx = 0.0f;
        if (this.once != 0) {
            this.myX = this.posx;
            this.myZ = this.posz;
            this.once = 0;
        }
        if (this.just_spawned != 0) {
            this.dir = this.world.rand.nextFloat() * (float)Math.PI;
            if (this.world.rand.nextInt(2) == 1) {
                this.dir *= -1.0f;
            }
            if (this.world.rand.nextInt(30) != 1) {
                this.radius = 3 + this.world.rand.nextInt(4);
                this.depth = 2 + this.world.rand.nextInt(3);
                this.speed = this.world.rand.nextFloat() / 5.0f;
            } else {
                this.radius = 6 + this.world.rand.nextInt(5);
                this.depth = 4 + this.world.rand.nextInt(4);
                this.speed = this.world.rand.nextFloat() / 20.0f;
            }
            this.create_island();
            this.ticker = this.world.rand.nextInt(50);
            this.dirchange = this.world.rand.nextInt(10000);
        }
        --this.ticker;
        if (this.ticker <= 0) {
            this.update_island();
            this.ticker = 20 + this.world.rand.nextInt(10);
        }
        --this.dirchange;
        if (this.dirchange <= 0) {
            this.dirchange = this.world.rand.nextInt(10000);
            this.dir = this.world.rand.nextFloat() * (float)Math.PI;
            if (this.world.rand.nextInt(2) == 1) {
                this.dir *= -1.0f;
            }
        }
        this.just_spawned = 0;
        if (this.world.rand.nextInt(1000) == 1) {
            Entity k;
            boolean found = false;
            List nearby_list = null;
            nearby_list = DangerZone.server.entityManager.findEntitiesInRange(10.0f, this.dimension, this.posx, this.posy, this.posz);
            if (nearby_list != null && !nearby_list.isEmpty()) {
                Entity e = null;
                ListIterator li = nearby_list.listIterator();
                while (li.hasNext()) {
                    e = (Entity)li.next();
                    if (!(e instanceof Triffid)) continue;
                    found = true;
                    break;
                }
            }
            if (!found && (k = this.world.createEntityByName("OreSpawn:Triffid", this.dimension, this.posx + (double)this.world.rand.nextInt(2) - (double)this.world.rand.nextInt(2), this.posy + 1.0, this.posz + (double)this.world.rand.nextInt(2) - (double)this.world.rand.nextInt(2))) != null) {
                k.init();
                this.world.spawnEntityInWorld(k);
            }
        }
        super.update(deltaT);
    }

    public void writeSelf(Properties prop, String tag) {
        super.writeSelf(prop, tag);
        prop.setProperty(String.format("%s%s", tag, "JustSpawned"), String.format("%d", this.just_spawned));
        prop.setProperty(String.format("%s%s", tag, "Idepth"), String.format("%d", this.depth));
        prop.setProperty(String.format("%s%s", tag, "Iradius"), String.format("%d", this.radius));
        prop.setProperty(String.format("%s%s", tag, "Ispeed"), String.format("%f", Float.valueOf(this.speed)));
        prop.setProperty(String.format("%s%s", tag, "Idir"), String.format("%f", Float.valueOf(this.dir)));
    }

    public void readSelf(Properties prop, String tag) {
        super.readSelf(prop, tag);
        this.just_spawned = Utils.getPropertyInt((Properties)prop, (String)String.format("%s%s", tag, "JustSpawned"), (int)0, (int)1, (int)0);
        this.depth = Utils.getPropertyInt((Properties)prop, (String)String.format("%s%s", tag, "Idepth"), (int)1, (int)8, (int)2);
        this.radius = Utils.getPropertyInt((Properties)prop, (String)String.format("%s%s", tag, "Iradius"), (int)1, (int)12, (int)5);
        this.speed = Utils.getPropertyFloat((Properties)prop, (String)String.format("%s%s", tag, "Ispeed"), (float)0.0f, (float)1.0f, (float)0.1f);
        this.dir = Utils.getPropertyFloat((Properties)prop, (String)String.format("%s%s", tag, "Idir"), (float)-3.14159f, (float)3.14159f, (float)0.0f);
    }

    private void create_island() {
        double deltadir = 0.04487989428571429;
        double deltamag = 0.21f;
        int bid = 0;
        int ixlast = 0;
        int izlast = 0;
        int i = 0;
        while (i < this.depth) {
            izlast = 0;
            ixlast = 0;
            double curdir = -3.1415926;
            while (curdir < 3.1415926) {
                double tradius = this.radius;
                tradius /= (double)(i + 1);
                float dx = (float)Math.cos(curdir + (double)this.dir);
                float dz = (float)Math.sin(curdir + (double)this.dir);
                double h = 0.75;
                while (h < tradius) {
                    int ix = (int)(this.posx + (double)dx * h);
                    int iz = (int)(this.posz + (double)dz * h);
                    if (ix != ixlast || iz != izlast) {
                        ixlast = ix;
                        izlast = iz;
                        if (i == 0) {
                            bid = this.world.getblock(this.dimension, ix, (int)this.posy - i + 1, iz);
                            if (!Blocks.isSolid((int)bid)) {
                                if (this.world.rand.nextInt(5000) == 1) {
                                    this.FastSetBlock(ix, (int)this.posy - i + 1, iz, Blocks.waterstatic.blockID);
                                } else {
                                    this.FastSetBlock(ix, (int)this.posy - i + 1, iz, OreSpawnMain.nofalldirt.blockID);
                                    if (this.world.rand.nextInt(20) == 1 && this.world.getblock(this.dimension, ix, (int)this.posy - i + 2, iz) == 0) {
                                        if (this.world.rand.nextInt(2) == 1) {
                                            this.FastSetBlock(ix, (int)this.posy - i + 2, iz, OreSpawnMain.blockflower_pink.blockID);
                                        } else {
                                            this.FastSetBlock(ix, (int)this.posy - i + 2, iz, OreSpawnMain.blockflower_blue.blockID);
                                        }
                                    }
                                }
                            } else if (bid == Blocks.stopblock.blockID) {
                                this.deadflag = true;
                                return;
                            }
                        } else if (this.world.rand.nextInt(10) == 1) {
                            this.FastSetBlock(ix, (int)this.posy - i + 1, iz, Blocks.orediamond.blockID);
                        } else {
                            this.FastSetBlock(ix, (int)this.posy - i + 1, iz, Blocks.greystone.blockID);
                        }
                    }
                    h += deltamag;
                }
                curdir += deltadir;
            }
            ++i;
        }
    }

    private void update_island() {
        double deltadir = 0.04487989428571429;
        double deltamag = 0.21f;
        int ixlast = 0;
        int izlast = 0;
        this.myX += (double)this.speed * Math.cos(this.dir);
        this.myZ += (double)this.speed * Math.sin(this.dir);
        int mx = (int)this.myX;
        int mz = (int)this.myZ;
        int px = (int)this.posx;
        int pz = (int)this.posz;
        if (mx != px || mz != pz) {
            int iz;
            int ix;
            double h;
            double tradius;
            double curdir;
            int i = 0;
            while (i < this.depth) {
                izlast = 0;
                ixlast = 0;
                curdir = -3.3;
                while (curdir < 3.3) {
                    tradius = this.radius;
                    tradius /= (double)(i + 1);
                    h = 0.75;
                    while (h < tradius) {
                        h += deltamag;
                    }
                    if ((h -= deltamag) < 0.75) {
                        h = 0.75;
                    }
                    float dx = (float)Math.cos(curdir + (double)this.dir);
                    float dz = (float)Math.sin(curdir + (double)this.dir);
                    while (h < tradius + deltamag) {
                        ix = (int)(this.posx + (double)dx * h);
                        iz = (int)(this.posz + (double)dz * h);
                        if (ix != ixlast || iz != izlast) {
                            ixlast = ix;
                            izlast = iz;
                            this.FastSetBlock(ix, (int)this.posy - i + 1, iz, 0);
                        }
                        h += deltamag / 2.0;
                    }
                    curdir += deltadir / 2.0;
                }
                ++i;
            }
            this.posx = (int)this.myX;
            this.posx += 0.5;
            this.posz = (int)this.myZ;
            this.posz += 0.5;
            i = 0;
            while (i < this.depth) {
                izlast = 0;
                ixlast = 0;
                curdir = -3.1415926;
                while (curdir < 3.1415926) {
                    tradius = this.radius;
                    tradius /= (double)(i + 1);
                    h = 0.75;
                    while (h < tradius) {
                        h += deltamag;
                    }
                    if ((h -= deltamag * 10.0) < 0.75) {
                        h = 0.75;
                    }
                    while (h < tradius) {
                        ix = (int)(this.posx + Math.cos(curdir + (double)this.dir) * h);
                        iz = (int)(this.posz + Math.sin(curdir + (double)this.dir) * h);
                        if (ix != ixlast || iz != izlast) {
                            int bid;
                            ixlast = ix;
                            izlast = iz;
                            if (i == 0) {
                                bid = this.world.getblock(this.dimension, ix, (int)this.posy - i + 1, iz);
                                if (!Blocks.isSolid((int)bid)) {
                                    if (this.world.rand.nextInt(5000) == 1) {
                                        this.FastSetBlock(ix, (int)this.posy - i + 1, iz, Blocks.waterstatic.blockID);
                                    } else {
                                        this.FastSetBlock(ix, (int)this.posy - i + 1, iz, OreSpawnMain.nofalldirt.blockID);
                                        if (this.world.rand.nextInt(20) == 1 && this.world.getblock(this.dimension, ix, (int)this.posy - i + 2, iz) == 0) {
                                            if (this.world.rand.nextInt(2) == 1) {
                                                this.FastSetBlock(ix, (int)this.posy - i + 2, iz, OreSpawnMain.blockflower_pink.blockID);
                                            } else {
                                                this.FastSetBlock(ix, (int)this.posy - i + 2, iz, OreSpawnMain.blockflower_blue.blockID);
                                            }
                                        }
                                    }
                                } else if (bid == Blocks.stopblock.blockID) {
                                    this.deadflag = true;
                                    return;
                                }
                            } else {
                                bid = this.world.getblock(this.dimension, ix, (int)this.posy - i + 1, iz);
                                if (bid == Blocks.stone.blockID) {
                                    Explosion.boom((Entity)this, (World)this.world, (int)this.dimension, (double)ix, (double)((int)(this.posy - (double)i + 1.0)), (double)iz, (int)10, (boolean)true);
                                } else if (this.world.rand.nextInt(10) == 1) {
                                    this.FastSetBlock(ix, (int)this.posy - i + 1, iz, Blocks.orediamond.blockID);
                                } else {
                                    this.FastSetBlock(ix, (int)this.posy - i + 1, iz, Blocks.greystone.blockID);
                                }
                            }
                        }
                        h += deltamag / 2.0;
                    }
                    curdir += deltadir / 2.0;
                }
                ++i;
            }
        }
    }

    private void FastSetBlock(int ix, int iy, int iz, int id) {
        this.world.setblock(this.dimension, ix, iy, iz, id);
    }

    public void doDeathDrops() {
        Utils.doDropRand((World)this.world, (int)OreSpawnMain.islandblock.blockID, (int)0, (float)1.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        super.doDeathDrops();
    }

    public Texture getTexture() {
        if (this.texture == null) {
            this.texture = TextureMapper.getTexture((String)"orespawnres/skins/Islandtexture.png");
        }
        return this.texture;
    }

    public void setBaby(boolean tf) {
    }
}

